package com.elitesland.sale.api.vo.resp.shop.app;

import com.elitesland.sale.api.vo.resp.shop.BipItemSkuRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/09/27/17:57
 * @Description:
 */
@Data
@ApiModel(description = "订单子单的商品信息")
public class BipOrderDItemRespVO implements Serializable {


    private static final long serialVersionUID = 5211673570036072564L;
    @ApiModelProperty("订单明细id")
    private Long id;

    @ApiModelProperty("订单明细父id")
    private Long pid;

    @ApiModelProperty("商品类型 ITM：ITEM_TYPE")
    private String itemType;

    @ApiModelProperty("订单id")
    private Long orderId;

    @ApiModelProperty("订单单号")
    private String orderDocNo;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品SKU id")
    private Long skuId;

    @ApiModelProperty("商品SKU编码")
    private String skuCode;

    @ApiModelProperty("商品中心商品id")
    private Long relateItemId;

    @ApiModelProperty("客户id")
    private Long custId;

    @ApiModelProperty("商品图片id")
    private String itemPicFileCode;

    @ApiModelProperty(value = "商品SKU")
    private BipItemSkuRespVO itemSkuRespVO;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("客户标题")
    private String itemTitle;

    @ApiModelProperty("客户品牌id")
    private Long itmeBrandID;

    @ApiModelProperty(value = "商品属性")
    private String attr;

    @ApiModelProperty("客户品牌")
    private String itemBrand;

    @ApiModelProperty("客户品牌编码")
    private String itmeBrandCode;


    @ApiModelProperty("购买数量")
    private Long buyQty;

    @ApiModelProperty("购买时价格")
    private BigDecimal buyAmt;


    @ApiModelProperty("应付金额")
    private BigDecimal payAmt;

    @ApiModelProperty("已付金额")
    private BigDecimal payDoneAmt;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("商品规格")
    private String itemSpec;









}
