package com.elitesland.sale.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.crm.AllowShipRuleRespVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 客户信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@Data
public class CrmCustDTO implements Serializable {
    private static final long serialVersionUID = 1115612950910732596L;
    
    /**
     * 客户定义
     */
    private String custDef;
    
    /**
     * 父客户编码
     */
    private String preCustCode;
    
    /**
     * 父客户名称
     */
    private String preCustName;

    /**
     * 客户ID
     */
    private Long id;

    /**
     * 公司ID
     */
    private Long ouId;

    /**
     * 公司编号
     */
    private String ouCode;

    /**
     * 公司名称
     */
    private String ouName;

    /**
     * 客户编码
     */
    private String custCode;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 客户简称
     */
    private String custAbbr;

    /**
     * 区域
     */
    private String region;

    /**
     * 区域名称
     */
    private String regionName;

    /**
     * 客户分类
     */
    private String custType;

    /**
     * 客户分类名称
     */
    private String custTypeName;

    /**
     * 业务员ID
     */
    private Long agentEmpId;

    /**
     * 客户等级
     */
    private String custLevel;

    /**
     * 销售渠道
     */
    private String saleChannel;

    /**
     * 对应公司
     */
//    private String corOu;

    /**
     * 默认允发期code
     */
    private String allowShipRuleCode;

    @ApiModelProperty("客户组编码")
    private String cat10;

    @ApiModelProperty("客户组名称")
    private String cat11;

    private String cat12;

    /**
     * 允发最大批次数量
     */

    @ApiModelProperty(value = "允发最大批次数量")
    @SysCode(sys = "yst-sale", mod = "ALLOW_SHIP_BATCH_MAX")
    private String allowBatchMax;
    private String allowBatchMaxName;

    @ApiModelProperty(value = "允发期规则")
    private AllowShipRuleRespVO allowShipRuleRespVO;
}
