package com.elitesland.sale.api.service.common;

import java.util.List;

/**
 * @Author: Unicorn
 * @Description: 客户多级渠道
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */
public interface TreeBase<T,Long> {

    Long getId();

    Long getPid();

    /**
     * 是否是根节点
     * @param pid
     * @return
     */
    default boolean isTop(Long pid){
        return this.getPid().equals(pid);
    }

    /**
     * 设置子集合
     * @param list
     */
    void setSubs(List<T> list);
}
