package com.elitesland.sale.api.service.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: Unicorn
 * @Description: 客户多级渠道
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */
public class TreeUtil {
    private TreeUtil() {

    }

    /**
     * 转换树形结构
     * @param source 需要组装的数据
     * @param <P> 第一层数据的parentId，
     *           eg1 id="1" parentId=null ,topParentId=null 则 此数据为第一层数据
     *           eg2 id="1" parentId="i1" ,topParentId=i1 则 此数据为第一层数据
     *           eg3 id="1" parentId="i1" ,topParentId=null 则 此数据不为第一层数据
     * @param <T> 泛型
     * @return 分层之后的列表
     */
    public static <P,T extends TreeBase<T,P>> List<T> transfer(List<T> source,P topParentId){
        ArrayList<T> ts = new ArrayList<>(source);
        Iterator<T> iterator = ts.iterator();

        List<T> root = new ArrayList<>();
        //移除根数据
        while (iterator.hasNext()){
            T next = iterator.next();
            if (next.isTop(topParentId)){
                root.add(next);
                iterator.remove();
            }
        }

        Map<P, List<T>> parentMap = ts.stream()
                .filter(m->m.getPid()!=null)
                .collect(Collectors.groupingBy(T::getPid));
        for (T t : ts) {
            //设置子菜单（引用，因此会将相关数据加入其中，但是不得有循环，否则栈溢出）
            t.setSubs(parentMap.get(t.getId()));
        }
        return root.stream().peek(r -> r.setSubs(parentMap.get(r.getId()))).collect(Collectors.toList());
    }
}