package com.elitesland.sale.api.vo.param.crm;

import com.el.coordinator.core.common.jpa.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;


/**
 * @Author: Unicorn
 * @Description: 根据客户渠道编码分页查询客户信息入参
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */
@Data
@ApiModel
public class CustSaleChannelCustInfoParam extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -990835521589973466L;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty("客户渠道编码")
    @Size(min = 1,message = "客户渠道编码不能为空")
    private List<String> codes;
}
