package com.elitesland.sale.api.vo.param.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: Unicorn
 * @Description: 客户渠道入参
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */
@Data
@ApiModel
public class CustSaleChannelParam implements Serializable {
    private static final long serialVersionUID = 5263235248188596233L;

    /**
     * id
     */
    @ApiModelProperty("id")
    private Long id;

    /**
     * 客户渠道编码，不允许修改【QD01】
     */
    @ApiModelProperty("客户渠道编码，不允许修改【QD01】")
    @NotNull(message = "客户渠道编码不能为空")
    private String saleChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty("客户渠道名称")
    @NotNull(message = "客户渠道名称不能为空")
    private String saleChannelName;

    /**
     * 外部编码，默认为客户渠道编码
     */
    @ApiModelProperty("外部编码，默认为客户渠道编码")
    @NotNull(message = "外部编码不能为空")
    private String outCode;

    /**
     * 客户渠道描述
     */
    @ApiModelProperty("客户渠道描述")
    private String saleChannelDesc;

    /**
     * 是否最小渠道，0 否，1 是
     */
    @ApiModelProperty("是否最小渠道，0 否，1 是")
    private Integer saleChannelBasic;

    /**
     * 上级渠道id，默认0为根节点
     */
    @ApiModelProperty("上级渠道id，默认0为根节点")
    @NotNull(message = "上级渠道id不能为空")
    private Long pid;
}
