package com.elitesland.sale.api.vo.param.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: Unicorn
 * @Description: 批量转移客户入参
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */
@Data
@ApiModel
public class SaleChannelTransferParam implements Serializable {
    private static final long serialVersionUID = -4463727399630645595L;

    /**
     * id
     */
    @ApiModelProperty("id")
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 要转移的渠道code
     */
    @ApiModelProperty("要转移的渠道code")
    @NotNull(message = "要转移的渠道code不能为空")
    private String code;
}
