package com.elitesland.sale.api.vo.resp.crm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.convert.BigDecimalConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(description = "允发期")
public class AllowShipRuleRespVO implements Serializable {


    private static final long serialVersionUID = -2647976652577400918L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;


    @ApiModelProperty(value = "编码")
    private String code;


    @ApiModelProperty(value = "状态 UDC:yst-sale:ALLOW_SHIP_STATUS (ACTIVE:启用,CLOSED:禁用)")
    @SysCode(sys = "yst-sale", mod = "ALLOW_SHIP_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty(value = "算法 UDC:yst-sale:ALLOW_SHIP_ALGORITHM (RESIDUE_DAY:剩余有效期天数 ,RESIDUE_RATIO:剩余有效期比例)")
    @SysCode(sys = "yst-sale", mod = "ALLOW_SHIP_ALGORITHM")
    private String algorithm;
    private String algorithmName;


    @ApiModelProperty(value = "剩余允发期比例")
    private String residueAllowShipRatio;


    @ApiModelProperty(value = "剩余允发期小数")
    @Convert(converter = BigDecimalConvert.class)
    private BigDecimal residueAllowShipDecimal;


    @ApiModelProperty(value = "剩余允发期天数")
    private Integer residueAllowShipDay;


    @ApiModelProperty(value = "描述")
    private String allowDescribe;
}
