package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author: Unicorn
 * @Description: 客户信息
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CustSaleChannelCustInfoVo implements Serializable {
    private static final long serialVersionUID = -7138764188295865168L;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String saleChannelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String saleChannelName;

    /**
     * 外部编码
     */
    @ApiModelProperty("外部编码")
    private String outCode;

    /**
     * 渠道描述
     */
    @ApiModelProperty("渠道描述")
    private String saleChannelDesc;

    /**
     * 渠道层级
     */
    @ApiModelProperty("渠道层级")
    private Integer saleChannelLevel;

    /**
     * 上级渠道id
     */
    @ApiModelProperty("上级渠道id")
    private Long pid;

    /**
     * 上级渠道编码
     */
    @ApiModelProperty("上级渠道编码")
    private String pCoce;

    /**
     * 上级渠道名称
     */
    @ApiModelProperty("上级渠道名称")
    private String pName;
}
