package com.elitesland.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class CustSaleChannelDTO implements Serializable {
    private static final long serialVersionUID = 1085237261211030393L;

    private Long id;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty("客户渠道编码")
    private String saleChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty("客户渠道名称")
    private String saleChannelName;

    /**
     * 层级（0，1，2，3），最高3
     */
    @ApiModelProperty("层级（0，1，2，3），最高3")
    private Integer saleChannelLevel;

    /**
     * 是否最小渠道，0 否，1 是
     */
    @ApiModelProperty("是否最小渠道，0 否，1 是")
    private Integer saleChannelBasic;
    private String saleChannelBasicLabel;

    /**
     * 启用状态，0启用，1禁用
     */
    @ApiModelProperty("启用状态，0启用，1禁用")
    private Integer enabledStatus;
    private String enabledStatusLabel;

    /**
     * 外部编码，默认和sale_channel_code一致
     */
    @ApiModelProperty("外部编码，默认和sale_channel_code一致")
    private String outCode;

    /**
     * 客户渠道描述
     */
    @ApiModelProperty("客户渠道描述")
    private String saleChannelDesc;

    /**
     * 上级渠道id，0表示根节点
     */
    @ApiModelProperty("上级渠道id，0表示根节点")
    private Long pid;

    /**
     * 上级渠道编码
     */
    @ApiModelProperty("上级渠道编码")
    private String pCode;

    /**
     * 上级渠道名称
     */
    @ApiModelProperty("上级渠道名称")
    private String pName;

    /**
     * 所有上级渠道编码
     */
    @ApiModelProperty("所有上级渠道编码")
    private List<String> pCodes;
}
