package com.elitesland.sale.api.vo.resp.crm;

import com.elitesland.sale.api.service.common.TreeBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Author: Unicorn
 * @Description: 客户渠道节点信息
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */
@Data
@ApiModel
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CustSaleChannelNode implements TreeBase<CustSaleChannelNode,Long> {

    private Long id;

    private Long pid;

    private String code;

    private String name;

    private Integer level;

    /**
     * 是否最小渠道，0 否，1 是
     */
    private Integer saleChannelBasic;

    private Boolean isLeaf;

    private List<CustSaleChannelNode> treeNodes;

    /**
     * 设置子集合
     *
     * @param list
     */
    @Override
    public void setSubs(List<CustSaleChannelNode> list) {
        this.treeNodes = list;
    }
}
