package com.elitesland.sale.api.vo.resp.sal;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;

/**
 * @Author: Unicorn
 * @Description: 客户渠道导入
 * @Date: 2024/6/25 13:07
 * @Version: 1.0
 */
@Data
@ApiModel
public class CustSaleChannelExcelVo implements Serializable {
    private static final long serialVersionUID = 6832821501053841368L;

    /**
     * 渠道编码
     */
    @ExcelProperty(value = "渠道编码", index = 0)
    @ApiModelProperty("渠道编码，非空")
    private String saleChannelCode;

    /**
     * 渠道名称
     */
    @ExcelProperty(value = "渠道名称", index = 1)
    @ApiModelProperty("渠道名称，非空")
    private String saleChannelName;

    /**
     * 上级渠道编码
     */
    @ExcelProperty(value = "上级渠道编码", index = 2)
    private String pCode;

    /**
     * 渠道描述
     */
    @ExcelProperty(value = "渠道描述", index = 3)
    private String saleChannelDesc;

    /**
     * 是否末级渠道（0 是，1 否）
     */
    @ExcelProperty(value = "是否末级渠道（0 是，1 否）", index = 4)
    @ApiModelProperty("是否末级渠道（0 是，1 否），非空")
    private Integer isEnd;
}
