package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
@ApiModel(description = "卡券领用单展示")
public class SalCardTotalVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 7971853965370958839L;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    private String itemCode;

    private String itemName;

    @ApiModelProperty("卡券总数")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long cardCount;

    @ApiModelProperty("卡券最小卡号")
    @JsonSerialize(using = ToStringSerializer.class)
    private String startCardNo;

    @ApiModelProperty("卡券最大卡号")
    @JsonSerialize(using = ToStringSerializer.class)
    private String endCardNo;


}
