package com.elitesland.sale.api.vo.resp.sal;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.sale.api.vo.resp.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;


/**
 * 功能说明 实体类:SalCardWarnSetting
 *
 * @author meng
 * @date 2023-12-07 18:27:57
 */
@Data
@ApiModel(description = "库存安全提醒")
public class SalCardWarnSettingVO extends BaseModelVO implements Serializable {

	private static final long serialVersionUID =8420940955952571789L;

	/**
	 * 商品ID
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "商品ID")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long itemId;

	/**
	 * 商品CODE
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "商品CODE")
	private String itemCode;

	/**
	 * 商品NAME
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "商品NAME")
	private String itemName;

	/**
	 * 安全库存
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "安全库存")
	@JsonSerialize(using = ToStringSerializer.class)
	private BigDecimal safeInv;

	/**
	 * 租户ID
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "告警人")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long warnUserId;

	@ApiModelProperty(value = "告警人")
	private String warnUserName;




}
