package com.elitesland.sale.service;

import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.resp.crm.CustSaleChannelDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Author: Unicorn
 * @Description: 客户渠道RPC接口
 * @Date: 2024/6/20 13:07
 * @Version: 1.0
 */

@FeignClient(name = Application.NAME, path = CustSaleChannelRPCService.URI)
public interface CustSaleChannelRPCService {
    String URI = Application.URI_PREFIX + "/saleChannel";

    /**
     * 通过编码批量查询渠道信息
     * @param codes
     * @return
     */
    @PostMapping("/findByCodes")
    List<CustSaleChannelDTO> findByCodes(@RequestBody List<String> codes);
}
