package com.elitesland.sale.api.vo.param.component;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/6/25
 */
@Data
@ApiModel("业务员公共组件分页查询条件")
public class SalesmanParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 5452700158000384704L;

    /**
     * 员工名称/编号，支持模糊查询
     */
    @ApiModelProperty(value = "员工名称/编号，支持模糊查询")
    private String empCodeName;

    /**
     * 所属公司名称/编号，支持模糊查询
     */
    @ApiModelProperty(value = "所属公司名称/编号，支持模糊查询")
    private String ouCodeName;


    @ApiModelProperty(value = "状态")
    private Integer enableStatus;
    @ApiModelProperty(value = "ouId")
    private Long ouId;
    @ApiModelProperty(value = "公司编码")
    private String ouCode;
    @ApiModelProperty(value = "组织ID")
    private Long orgId;
    @ApiModelProperty(value = "组织code")
    private String orgCode;

    @ApiModelProperty(value = "登录账号")
    private String loginAccount;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("业务员类型")
    private List<String> salesmanTypeList;

    private List<String> codes;



    @ApiModelProperty("查看客户对应业务员")
    private String custCode;

}
