/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.sale.api.service.common;

import com.elitesland.sale.api.service.common.TreeBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TreeUtil {
    private TreeUtil() {
    }

    public static <P, T extends TreeBase<T, P>> List<T> transfer(List<T> source, P topParentId) {
        ArrayList<T> ts = new ArrayList<T>(source);
        Iterator<T> iterator = ts.iterator();
        ArrayList<TreeBase> root = new ArrayList<TreeBase>();
        while (iterator.hasNext()) {
            TreeBase next = (TreeBase)iterator.next();
            if (!next.isTop(topParentId)) continue;
            root.add(next);
            iterator.remove();
        }
        Map<Object, List<TreeBase>> parentMap = ts.stream().filter(m -> m.getPid() != null).collect(Collectors.groupingBy(TreeBase::getPid));
        for (TreeBase t : ts) {
            t.setSubs(parentMap.get(t.getId()));
        }
        return root.stream().peek(r -> r.setSubs((List)parentMap.get(r.getId()))).collect(Collectors.toList());
    }
}

