package com.elitesland.sale.api.vo.param.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 满减促销赠折扣信息明细 保存VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@ApiModel(description = "满减促销赠折扣信息明细 保存VO")
@Data
public class MktGiftSaveVO implements Serializable {

    private static final long serialVersionUID = -6736071199158601304L;

    @ApiModelProperty("赠品表ID")
    private Long id;

    @ApiModelProperty("折扣买赠商品ID")
    private Long discountGiftItemId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("库存量")
    private Long stockNum;
    @ApiModelProperty("可用库存量")
    private Long stockNowNum;

    @ApiModelProperty("买赠折扣编码")
    private String discountGiftCode;

    @ApiModelProperty("促销生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty("促销失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "商品sku编码")
    private String skuCode;

    @ApiModelProperty(value = "商品sku名称")
    private String skuName;

    @ApiModelProperty(value = "物料类型")
    private String materiel;

    @ApiModelProperty(value = "商品类型")
    private String type;

    @ApiModelProperty(value = "赠品数量")
    private Long giftNum;


    @ApiModelProperty(value = "已使用数量")
    private Long lockNum;
}