package com.elitesland.sale.api.vo.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public class StringLocalDateTimeConverter implements Converter<LocalDateTime> {
    
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";

    private static final String DATE_PATTERN_1 = "yyyy/MM/dd";

    private static final String DATE_PATTERN_2 = "yyyy-M-d";

    private static final String DATE_PATTERN_3 = "yyyy/M/d";

    private static final DateTimeFormatter defaultFormatter =  DateTimeFormatter.ofPattern(DEFAULT_DATE_PATTERN);

    private static final DateTimeFormatter formatter1 =  DateTimeFormatter.ofPattern(DATE_PATTERN_1);

    private static final DateTimeFormatter formatter2 =  DateTimeFormatter.ofPattern(DATE_PATTERN_2);

    private static final DateTimeFormatter formatter3 =  DateTimeFormatter.ofPattern(DATE_PATTERN_3);

    private static final List<DateTimeFormatter> formatters = new ArrayList<>();

    static {
        formatters.add(defaultFormatter);
        formatters.add(formatter1);
        formatters.add(formatter2);
        formatters.add(formatter3);
    }
    @Override
    public Class supportJavaTypeKey() {
        return null;
    }
    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }
    
    @Override
    public LocalDateTime convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String date = cellData.getStringValue();
        for (DateTimeFormatter formatter : formatters) {
            try {
                LocalDate localDate = LocalDate.parse(date,formatter);
                return LocalDateTime.of(localDate, LocalTime.of(0,0));
            } catch (Exception e) {
                log.error("{} can't parse date.", formatter);
            }
        }
        throw new BusinessException(date + "不是可解析的日期格式");
    }
    
    @Override
    public CellData convertToExcelData(LocalDateTime localDateTime, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
    
}
