package com.elitesland.sale.api.vo.save;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.sale.api.vo.convert.BigDecimalConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class AllowShipRuleImportVO implements Serializable {
    private static final long serialVersionUID = -1042853621536311519L;

    @ApiModelProperty(value = "编码")
    @ExcelProperty(index = 0)
    private String code;

    @ApiModelProperty(value = "名称")
    @ExcelProperty(index = 1)
    private String name;

    @ApiModelProperty(value = "算法")
    @ExcelProperty(index = 2)
    private String algorithmName;

//
//    @ApiModelProperty(value = "剩余允发期比例")
//    @ExcelProperty(index = 3)
//    private String residueAllowShipRatio;

    @ApiModelProperty(value = "剩余允发期小数")
    @Convert(converter = BigDecimalConvert.class)
    @ExcelProperty(index = 3)
    private BigDecimal residueAllowShipDecimal;


    @ApiModelProperty(value = "剩余允发期天数")
    @ExcelProperty(index = 4)
    private Integer residueAllowShipDay;

//    @ExcelProperty(index = 5)
//    private String statusName;

    @ApiModelProperty(value = "描述")
    @ExcelProperty(index = 5)
    private String allowDescribe;


}
