package com.elitesland.sale.api.vo.param.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 满减促销折扣信息主表 保存VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/18
 */
@ApiModel(description = "满减促销折扣信息主表 保存VO")
@Data
public class MktDiscountOffsetSaveVO implements Serializable {

    private static final long serialVersionUID = -791990610805110967L;

    @ApiModelProperty("主表ID")
    private Long id;

    @ApiModelProperty("满减促销编码")
    private String code;

    @ApiModelProperty("满减促销名称")
    private String name;

    @ApiModelProperty("促销生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty("促销失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty("客户等级")
    private String customLevel;

    @ApiModelProperty("销售公司ID")
    private Long ouId;

    @ApiModelProperty("销售组织ID")
    private Long buId;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("促销条件:0 件数 1 金额")
    private String type;

    @ApiModelProperty("促销状态")
    private String status;

    @ApiModelProperty("满减促销明细集合")
    private List<MktDiscountOffsetDSaveVO> details;
}
