package com.elitesland.sale.api.vo.resp.itm;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("替代物料")
public class AlterMatterVO implements Serializable {
    private static final long serialVersionUID = 2320042154165938372L;

    @ApiModelProperty("渠道类型")
    private String channelType;
    @ApiModelProperty("发货基地")
    private Long desId;

    @ApiModelProperty("spuId")
    private Long spuId;
    @ApiModelProperty("spu编码")
    private String spuCode;
    @ApiModelProperty("spu名称")
    private String spuName;

    @ApiModelProperty("商品ID")
    private Long itemId;
    @ApiModelProperty("SKU商品编号")
    private String itemCode;
    @ApiModelProperty("SKU商品名称")
    private String itemName;

    @ApiModelProperty("在当前渠道和基地是否上架")
    private Boolean isOnShelf;

    @ApiModelProperty("sku图片名称")
    private String skuImageFileName;

    @ApiModelProperty("sku图片fileCode")
    private String skuImageFileCode;

    @ApiModelProperty("最终价格")
    private BigDecimal finalPrice;
}
