package com.elitesland.sale.api.vo.resp.shop.app;

import com.elitesland.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.checkerframework.checker.units.qual.A;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
@Data
@ApiModel(description = "商品属性")
public class BipItemAttrAppRespVO implements Serializable {
    private static final long serialVersionUID = -6535252339857044367L;

    @ApiModelProperty(value = "所有属性", position = 1)
    private List<Attr> attrList;

    @ApiModelProperty(value = "SKU列表", position = 2)
    private List<Sku> skuList;

    @Data
    @ApiModel(value = "BipItemAttrAppRespVO_Attr", description = "属性")
    public static class Attr implements Serializable {
        private static final long serialVersionUID = -7122589836443627776L;

        @ApiModelProperty(value = "属性编号", position = 1)
        private String code;

        @ApiModelProperty(value = "属性名称", position = 2)
        private String name;

        @ApiModelProperty(value = "可选值列表", position = 2)
        private List<String> valueList;
    }

    @Data
    @ApiModel(value = "BipItemAttrAppRespVO_Sku", description = "sku")
    public static class Sku implements Serializable {
        private static final long serialVersionUID = -6551418320697253015L;

        @ApiModelProperty(value = "SKU记录的ID")
        private Long id;

        @ApiModelProperty(value = "商品名称", position = 1)
        private String itemName;

        @ApiModelProperty(value = "sku编号", position = 2)
        private String skuCode;

        @ApiModelProperty(value = "商品属性", position = 3)
        private List<BipItemSkuAttrRespVO> attrList;

        @ApiModelProperty(value = "基础价", position = 11)
        private BigDecimal price;

        @ApiModelProperty(value = "客户等级价", position = 11)
        private BigDecimal priceCust;

        @ApiModelProperty(value = "优惠价", position = 12)
        private BigDecimal priceDiscount;

        @ApiModelProperty(value = "特惠价", position = 12)
        private BigDecimal preferentialPrice;

        @ApiModelProperty(value = "是否一件代发", position = 21)
        private Boolean shipOne;

        @ApiModelProperty(value = "库存", position = 22)
        private Integer stock;

        @ApiModelProperty(value = "最小起订量", position = 23)
        private Integer limitBuy;

        @ApiModelProperty("是否冻结，true：冻结  false：未冻结")
        private Boolean freeze;
    }
}
