package com.elitesland.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/19/16:19
 * @Description:
 */
@Data
@ApiModel(description = "订单评价")
public class BipItemEvalRespVO implements Serializable {
    private static final long serialVersionUID = 4082963156386872554L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("订单主表id")
    private Long orderId;

    @ApiModelProperty("订单号")
    private String docNo;

    @ApiModelProperty("订单明细表id")
    private Long orderDId;

    @ApiModelProperty("商品id")
    private Long itemId;


    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品图片")
    private String itemImageCode;

    @ApiModelProperty("商品图片")
    private String itemImageCodeUrl;

    @ApiModelProperty("商品skuid")
    private Long skuId;

    @ApiModelProperty("商品sku编码")
    private String skuCode;

    @ApiModelProperty("商品sku图片")
    private Long itemSkuImageCode;

    @ApiModelProperty("总评价数")
    private Long numEval;

    @ApiModelProperty("好评数量")
    private Long numEvalGood;


    @ApiModelProperty("好评率")
    private BigDecimal rateEvalGood;

    @ApiModelProperty("好评率，分值形式")
    private BigDecimal scoreEval;

    @ApiModelProperty("商品属性")
    private String itemAttr;

    @ApiModelProperty("账户id")
    private Long custAccountId;

    @ApiModelProperty("账户名称")
    private String custAccountName;

    @ApiModelProperty("账户绑定电话")
    private String tel;

    @ApiModelProperty("评价内容")
    private String context;

    @ApiModelProperty("客户公司id")
    private Long ouId;

    @ApiModelProperty("客户公司编码")
    private String ouCode;

    @ApiModelProperty("客户公司名称")
    private String ouName;

    @ApiModelProperty("是否已回复 0 未回复 1 回复")
    private Boolean isReplay;

    @ApiModelProperty("回复者id")
    private Long replayUserId;

    @ApiModelProperty("回复者名称")
    private String replayName;

    @ApiModelProperty("回复内容")
    private String replayContext;

    @ApiModelProperty("回复时间")
    private LocalDateTime replayTime;

    @ApiModelProperty("商品评分")
    private String itemEvalScore;

    @ApiModelProperty("物流评分")
    private String logicEvalScore;

    @ApiModelProperty("评价图片")
    private String evalFileCodes;

    @ApiModelProperty("是否显示")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean isShow;

    @ApiModelProperty("评价时间")
    private LocalDateTime createTime;

    @ApiModelProperty("是否公开 0 公开 1 不公开")
    private Boolean isPublic;

    @ApiModelProperty("评价图片列表")
    private List<String> evalFileCodeList;

}
