package com.elitesland.sale.service;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.Application;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcParam;
import com.elitesland.sale.api.vo.resp.crm.MktGiftReduceRpcParam;
import com.elitesland.sale.api.vo.resp.crm.MktGiftUpdateNumRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = MktDiscountGiftRpcService.URI)
public interface MktDiscountGiftRpcService {

    String URI = Application.URI_PREFIX + "/gift";



    @PostMapping("/getGiftByParam")
    ApiResult<MktDiscountGiftRpcDTO> getGiftByParam(@RequestBody MktDiscountGiftRpcParam param);

    @PostMapping("/getGiftListByParam")
    ApiResult<List<MktDiscountGiftRpcDTO>> getGiftListByParam(@RequestBody MktDiscountGiftRpcParam param);

    /**
     * 锁定释放赠品数量
     * @param param
     * @return
     */
    @PostMapping("/updateGiftLocknum")
    ApiResult<Object> updateGiftLocknum(@RequestBody MktGiftUpdateNumRpcParam param);


    @PostMapping("/reduceGiftNum")
    ApiResult<Object> reduceGiftNum(@RequestBody MktGiftReduceRpcParam param);

}
