package com.elitesland.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 满减折扣-主表VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/18
 */
@ApiModel(description = "满减折扣-主表VO")
@Data
public class MktDiscountOffsetRespVO implements Serializable {

    private static final long serialVersionUID = 8939968094808276368L;

    @ApiModelProperty(value = "折扣主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "折扣编码")
    private String code;

    @ApiModelProperty(value = "折扣名称")
    private String name;

    @ApiModelProperty(value = "折扣生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty(value = "折扣失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty(value = "客户等级")
    @SysCode(sys = "yst-sale", mod = "CUST_LEVEL")
    private String customLevel;
    private String customLevelName;

    @ApiModelProperty(value = "销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "销售公司编码")
    private String ouCode;

    @ApiModelProperty(value = "销售公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "销售组织编码")
    private String buCode;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty(value = "'促销条件:0 件数 1 金额")
    @SysCode(sys = "yst-sale", mod = "DISCOUNT_OFFSET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty(value = "促销状态")
    @SysCode(sys = "yst-sale", mod = "DISCOUNT_OFFSET_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty(value = "促销明细集合")
    private List<MktDiscountOffsetRespDVO> details;
}
