package com.elitesland.sale.api.vo.resp.pro;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 返回参数 - 合同验收单明细
 *
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-22 09:58:21
 */
@ApiModel(description = "合同验收单明细")
@Data
public class SalAcceptanceDDetailRespVO implements Serializable {

    private static final long serialVersionUID = 5885044031028735253L;

    @ApiModelProperty("主表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;

    @ApiModelProperty("订单不含税金额")//sod
    private BigDecimal soNetAmt;

    @ApiModelProperty("验收状态")
    private String examStatus;

    @ApiModelProperty("本次验收金额(含税)")
    private BigDecimal acAmt;

    @ApiModelProperty("本次验收数量(签售数量)")
    private BigDecimal acQty;

    @ApiModelProperty("本次验收不含税金额")
    private BigDecimal acNetAmt;

    @ApiModelProperty("本次验收税额")
    private BigDecimal acTaxAmt;

    @ApiModelProperty("待验收数量")
    private BigDecimal aeQty;

    @ApiModelProperty("签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty("已签收总数量")
    private BigDecimal acedQtyTotal;

    @ApiModelProperty("验收中总数量")
    private BigDecimal acingQtyTotal;

//    @ApiModelProperty("安装工单验收数量")
//    private BigDecimal

    @ApiModelProperty("签收含税金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("签收不含税金额")
    private BigDecimal confirmNetAmt;

    @ApiModelProperty("签收税额")
    private BigDecimal confirmTaxAmt;

    // 销售单信息
    @ApiModelProperty(value = "销售订单号")
    private String soNo;

    //订单号
    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "销售订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long soDId;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("规格型号")
    private String itemSpec;

    @ApiModelProperty("品牌")
    private String itemBrand;

    @ApiModelProperty("品牌")
    private String itemBrandName;

    @ApiModelProperty("订单数量")
    private BigDecimal soQty;

    @ApiModelProperty("计量单位")
    private String uom;
    private String uomName;

    @ApiModelProperty("发货数量")
    private BigDecimal qty;

    @ApiModelProperty("单价(含税)")
    private BigDecimal price;

    @ApiModelProperty("订单含税金额")
    private BigDecimal soAmt;

    @ApiModelProperty("订单税额")
    private BigDecimal soTaxAmt;

    @ApiModelProperty("税率编码")
    private String taxRateNo;
    private String taxRateDesc;

    @ApiModelProperty("税率")
    private BigDecimal soTaxRate;

    @ApiModelProperty("已验收数量")
    private BigDecimal examedQty;

    @ApiModelProperty("验收中数量")
    private BigDecimal examingQty;

}
