package com.elitesland.sale.api.vo.resp.crm;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class GiftRpcDTO implements Serializable {
    private static final long serialVersionUID = -8294676032679658459L;


    @ApiModelProperty(value = "赠品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "关联商品ID")
    private Long discountGiftItemId;
    @ApiModelProperty(value = "code")
    private String discountGiftCode;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "库存量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stockNum;

    @ApiModelProperty(value = "当前库存量")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long stockNowNum;

    @ApiModelProperty(value = "库存锁定量")
    private Long lockNum;

    @ApiModelProperty(value = "生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty(value = "失效时间")
    private LocalDateTime validEtime;

    @ApiModelProperty(value = "赠品数量")
    private Long giftNum;




    @ApiModelProperty(value = "实际赠送数量")
    private Long realNum;
}
