package com.elitesland.sale.api.vo.save;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/11/17 23:03
 */
@Data
@ApiModel(description = "潜在客户导入模板")
public class CrmScustImportSaveVO implements Serializable {
    private static final long serialVersionUID = 3816003810794900397L;

    @ApiModelProperty(value = "客户id")
    private Long id;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    @ApiModelProperty(value = "外部系统客户编码")
    private String custCode2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "客户名称", required = true)
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    private Long ouId;

    @ApiModelProperty(value = "公司编号", required = true)
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织ID", required = true)
    private Long buId;
    @ApiModelProperty(value = "销售组织编号")
    private String buCode;
    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String region;
    private String regionName;

    @ApiModelProperty(value = "客户管理专员id", required = true)
    private Long agentEmpId;
    private String agentEmpCode;
    private String agentEmpName;

    @ApiModelProperty(value = "客户分类 [UDC]CRM:CUST_TYPE")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    @ApiModelProperty(value = "意向等级 [UDC]CRM:SCUST_INTENT_LEVEL")
    @SysCode(sys = "yst-sale", mod = "SCUST_INTENT_LEVEL")
    private String intentLevel;
    private String intentLevelName;

    @ApiModelProperty(value = "最近跟进日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate lastFollowupDate;

    @ApiModelProperty(value = "客户行业 [UDC]COM:INDUSTRY")
    @SysCode(sys = "yst-supp", mod = "INDUSTRY")
    private String custIndustry;
    private String custIndustryName;

    @ApiModelProperty(value = "客户来源 [UDC]CRM:CUST_SOURCE")
    @SysCode(sys = "yst-sale", mod = "CUST_SOURCE")
    private String custSource;
    private String custSourceName;

    @ApiModelProperty(value = "客户规模")
    private String compScale;

    @ApiModelProperty(value = "客户年营业额")
    private String compTurnover;

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "客户联系人电话")
    private String mobile;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String email;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String detailAddr;

    @ApiModelProperty(value = "是否是燃气用户 0:是 | 1:否")
    private String es2;

    @ApiModelProperty(value = "其他1")
    private String es3;

}
