package com.elitesland.sale.api.service;

import com.elitesland.sale.api.dto.BipCustPriceDTO;
import com.elitesland.sale.api.dto.BipInvItemDTO;
import com.elitesland.sale.api.vo.param.pri.*;
import com.elitesland.sale.api.vo.resp.pri.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:12 下午
 */
public interface PriSalePriceService {
    /**
     * 分页查询B端商品价格
     * @param searchParam 搜索参数
     * @return
     */
    PagingVO<PriSalePricePageRespVO> query(PriSalePricePagingParam searchParam);

    /**
     * 根据相关条件查询已存在的价格
     * @param ouId 公司ID
     * @param custIds 客户IDs
     * @param custGroup 客户等级
     * @param priceType 价格类型
     */
    List<PriSalePricePageRespVO> queryExistPrice(Long ouId, List<Long> custIds, String custGroup, List<Long> itemIds, String priceType);
    List<PriSalePricePageRespVO> queryExistPrice(List<Long> ouIds, List<Long> itemIds);

    /**
     * 开单获取对外销售价
     * @param param
     * @return
     */
    ApiResult<PriSalePriceRespVO> querySalePrice(PriSalePriceQueryParam param);

    /**
     * 获取内部结算价
     * @param param
     * @return
     */
    ApiResult<PriCrossPriceRespVO> queryCrossPrice(PriCrossPriceQueryParam param);

    /**
     * 获取单个价格，包括商品信息
     * @param param 请求参数
     * @return
     */
    PriSalePriceDetailVO queryOnePrice(PriSalePriceQueryOneParam param);

    /**
     * 查询指定类型价格
     * @param param
     * @return
     */
    PriSalePriceTypeRespVO queryPrice(PriSalePriceTypeQueryParam param);

    /**
     * 获取指定商品的相关客户价
     *
     * @param itemId 商品ID
     * @return 客户价
     */
    ApiResult<List<BipCustPriceDTO>> queryCustPrice(Long itemId);

    /**
     * 发票管理查询 商品的 规格 税率 未税金额 等信息
     * @param skuCodes  商品sku
     * @return 查询到的信息
     */
    List<BipInvItemDTO> queryItemByItemCode(List<String> skuCodes);


    /**
     * 查询基本价格信息
     * @param sku
     * @return
     */
    List<BipInvItemDTO> queryBasePriceByItemCode(String sku);

}
