package com.elitesland.sale.api.vo.resp.shop;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * 首单特惠
 *
 * @author Shadow
 * @since 2021-08-11 09:08:08
 */
@Data
@ApiModel(value = "BipCouponVO", description = "首单特惠")
public class FirstSpecialVO implements Serializable {

	private static final long serialVersionUID = -1980903438713940980L;
	@ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("ouId")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-sale", mod = "SPECIAL_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("优先级")
    private Integer sort;

    @ApiModelProperty("明细")
    List<FirstSpecialItemVO> list;


}
