package com.elitesland.yst.supportdomain.provider.item.dto;

import com.elitesland.yst.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Chris
 * @date 2021-05-27
 */
@Data
@ApiModel("经营目录商品SKU分页DTO")
public class ItmItemBusinessRpcPagingDTO implements Serializable {

    private static final long serialVersionUID = 2280221514194914648L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品SKU Id")
    private Long itemId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品经营目录 Id")
    private Long businessId;

    /**
     * 商品SKU编号
     */
    @ApiModelProperty("商品SKU编号")
    private String itemCode;

    /**
     * 商品SKU名称
     */
    @ApiModelProperty("商品SKU名称")
    private String itemName;

    /**
     * 商品简称
     */
    @ApiModelProperty("商品简称")
    private String itemAbbr;

    /**
     * 外部编号
     */
    @ApiModelProperty("外部编号")
    private String outerCode;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barCode;

    /**
     * 品类(SPU)编号
     */
    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    /**
     * 品类(SPU)全路径名称
     */
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "ITM", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "ITM", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    /**
     * 商品类型 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_STATUS")
    @SysCode(sys = "ITM", mod = "ITEM_STATUS")
    private String itemStatus;
    private String itemStatusName;

    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String spec;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    String packageSpec;

    /**
     * 主计量单位
     */
    @ApiModelProperty("主计量单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 默认销售单位 [UDC]COM:UOM
     */
    @ApiModelProperty("默认销售单位 [UDC]COM:UOM")
    @SysCode(sys = "COM", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    /**
     * 默认采购单位
     */
    @ApiModelProperty("默认采购单位")
    @SysCode(sys = "COM", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(sys = "COM", mod = "WEIGHT_UNIT")
    private String weightUnit;
    private String weightUnitName;

    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 体积单位 [UDC]COM:VOLUME_UNIT
     */
    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    @SysCode(sys = "COM", mod = "VOLUME_UNIT")
    private String volumeUnit;
    private String volumeUnitName;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    @SysCode(sys = "ITM", mod = "ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;

    /**
     * 税码(进项)
     */
    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率(进项)，小于1的小数，保留8位，四舍五入
     */
    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;

    /**
     * 税率描述(进项)
     */
    @ApiModelProperty("税率描述(进项)")
    private String taxRateDesc;

    /**
     * 税码2(销项)
     */
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    /**
     * 税率2(销项)
     */
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    /**
     * 税率2描述(销项)
     */
    @ApiModelProperty("税率2描述(销项)")
    private String taxRate2Desc;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    /**
     * 是否需要安装
     */
    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(sys = "COM", mod = "TIME_UNIT")
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String buCode;

    /**
     * 商品生命状态
     */
    @ApiModelProperty("商品生命状态")
    private String itemLifeStatus;
}
