package com.elitesland.yst.supportdomain.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author : Scott.zhang(zhang hang)
 * @date : 2021/07/14/15:54
 */
@Data
@ApiModel(description = "品类信息dto")
public class ItmItemCateContrPropDTO implements Serializable {

    private static final long serialVersionUID = -6863624139596613165L;
    /**
     * 商品id
     */
    @ApiModelProperty(value = "商品id")
    private Long id;
    /**
     * 大类编码
     */
    @ApiModelProperty(value = "大类编码")
    private String bigCateCode;
    /**
     * 中类编码
     */
    @ApiModelProperty(value = "中类编码")
    private String midCateCode;
    /**
     * 小类编码
     */
    @ApiModelProperty(value = "小类编码")
    private String smallCateCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String itemCateName;

    /**
     * 产品段值码
     */
    @ApiModelProperty(value = "产品段值码")
    private String priceGroup;
    /**
     * 财务商品分类码
     */
    @ApiModelProperty(value = "财务商品分类码")
    private String priceGroup2;
    /**
     * 费用类码
     */
    @ApiModelProperty(value = "费用类码")
    private String priceGroup3;

    /**
     * 财务分类值
     */
    @ApiModelProperty("财务分类")
    private String controlParamValue;

    @ApiModelProperty("管控参数编码")
    private String controlParamCode;


}
