package com.elitesland.yst.supportdomain.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/2/8
 */
@Data
@ApiModel("商品品类反参")
public class ItmItemCateTreeRpcDTO{

    private static final long serialVersionUID = 2356088600319301020L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "父级ID")
    private Long pid;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    private String code;

    /**
     * 路径
     */
    @ApiModelProperty(value = "路径")
    private String path;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 科目级别
     */
    @ApiModelProperty(value = "科目级别")
    private Integer level;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String itemCateName;

    /**
     * 是否基础类目（0：不是，1：是）
     */
    @ApiModelProperty(value = "是否基础类目（0：不是，1：是）")
    private Integer itemCateIsBasic;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String status;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    /**
     * 品类描述
     */
    @ApiModelProperty(value = "品类描述")
    private String itemCateDesc;

    /**
     * 商品品类下级
     */
    @ApiModelProperty(value = "商品品类下级")
    private List<ItmItemCateTreeRpcDTO> treeNodes;

}
