package com.elitesland.yst.supportdomain.provider.item.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * @author Chris
 * @date 2021-04-12
 */
@Data
public class ItmItemQualifyRpcDTO implements Serializable {

    private static final long serialVersionUID = -7951643466587041382L;

    /**
     * 资质编号
     */
    @ApiModelProperty(value = "资质编号")
    private String qualifyNo;

    /**
     * 资质名称
     */
    @ApiModelProperty(value = "资质名称")
    private String qualifyName;

    /**
     * 资质类型 [UDC]ITM:QUALIFY_TYPE
     */
    @ApiModelProperty(value = "资质类型 [UDC]ITM:QUALIFY_TYPE")
    private String qualifyType;

    /**
     * 资质证照状态 [UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty(value = "资质证照状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String qualifyStatus;

    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    /**
     * 资质文件编号
     */
    @ApiModelProperty(value = "资质文件编号")
    private String qualifyFileCode;

    /**
     * 资质文件名称
     */
    @ApiModelProperty(value = "资质文件名称")
    private String qualifyFileName;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;
}
