package com.elitesland.yst.supportdomain.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2021/12/2116:33
 */
@Data
public class ItmItemUomConvCalcRpcDTO implements Serializable {
    private static final long serialVersionUID = -3274576646123852680L;

    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 商品主计量单位
     */
    @ApiModelProperty("商品主计量单位")
    private String mainUom;

    /**
     * 业务单位
     */
    @ApiModelProperty("业务单位")
    private String businessUom;

    /**
     * 转换后数据
     */
    @ApiModelProperty("转换后数据")
    private BigDecimal convertedNum;

}
