package com.elitesland.yst.supportdomain.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@ApiModel("商品SKU单位转换系数DTO")
public class ItmItemUomConvRpcDTO implements Serializable {

    private static final long serialVersionUID = 6506870590117667986L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 商品SKU ID
     */
    @ApiModelProperty("商品SKU ID")
    private Long itemId;


    /**
     * 商品编码
     */
    @ApiModelProperty("商品编码")
    private String itemCode;

    /**
     * 从单位类型 [UDC]COM:UOM
     */
    @ApiModelProperty(value = "从单位类型 [UDC]COM:UOM")
    private String fromUom;

    /**
     * 到单位类型 [UDC]COM:UOM
     */
    @ApiModelProperty(value = "到单位类型 [UDC]COM:UOM")
    private String toUom;

    /**
     * 转换系数
     */
    @ApiModelProperty(value = "转换系数")
    private BigDecimal ratio;

    /**
     * 逆转换系数
     */
    @ApiModelProperty(value = "逆转换系数")
    private BigDecimal revertRatio;
}
