package com.elitesland.yst.supportdomain.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-02-22
 */
@Data
@ApiModel(value = "itm_brand", description = "品牌详情数据结构")
public class ItmReBrandDTO implements Serializable {

    private static final long serialVersionUID = 5944143122274803054L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    /**
     * 品牌英文名
     */
    @ApiModelProperty(value = "品牌英文名")
    private String brandEnName;

    /**
     * 品牌首字母
     */
    @ApiModelProperty(value = "品牌首字母")
    private String brandInitial;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String status;

}
