package com.elitesland.yst.supportdomain.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/12
 */
@Data
@ApiModel(value = "商品品牌入参", description = "采购基础数据、采购价格、采购付款、供应商获取品牌信息入参")
public class ItmBrandPartParam implements Serializable {
    private static final long serialVersionUID = -2159585042319935226L;

    /**
     * 品牌ID
     */
    @ApiModelProperty("品牌ID")
    private Long id;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    /**
     * 品牌ID集合
     */
    @ApiModelProperty("品牌ID集合")
    private List<Long> ids;

    /**
     * 品牌编码集合
     */
    @ApiModelProperty(value = "品牌编码集合")
    private List<String> brandCodes;
}
