package com.elitesland.yst.supportdomain.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/25
 */
@Data
@ApiModel(description = "供应链商品分页条件查询")
public class ItmBrandSupplyPagingParam implements Serializable {

    private static final long serialVersionUID = -7646364992098184696L;
    @ApiModelProperty(value = "页码,默认为1", example = "0")
    private Integer current = 0;

    /**
     * 页大小,默认为10
     */
    @ApiModelProperty(value = "页大小,默认为10", example = "10")
    private Integer size = 10;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String brandName;
}
