package com.elitesland.yst.supportdomain.provider.item.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2021/11/1114:42
 */
@Data
public class ItmCheckLifeStatusRpcParam implements Serializable {
    private static final long serialVersionUID = 5535154105512894117L;

    /**
     * 业务编码
     */
    @ApiModelProperty(value = "业务编码")
    @NotNull(
            message = "业务编码不能为空"
    )
    private String businessCode;

    /**
     * 冻结状态
     */
    @ApiModelProperty(value = "冻结状态")
    @NotNull(
            message = "冻结状态不能为空"
    )
    private String itemLifeStatus;

    /**
     * 冻结时间
     */
    @ApiModelProperty(value = "冻结时间")
    private LocalDateTime statusTime;

    /**
     * 校验商品列表状态   商品列表使用
     */
    @ApiModelProperty(value = "商品编码列表-商品列表数据校验冻结")
    private List<String> itemCodes;

    /**
     * 校验经营目录状态   经营目录使用
     */
    @ApiModelProperty(value = "经营目录数据列表-经营目录数据校验冻结")
    private List<ItmCheckBusinessStatusRpcParam> businessList;


}
