package com.elitesland.yst.supportdomain.provider.item.param;

import com.elitesland.yst.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * @date 2021-05-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("商品DTO分页条件")
public class ItmItemRpcPagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -3822555526250684108L;

    /**
     * 品项编号/名称，支持模糊查询
     */
    @ApiModelProperty("品项编号/名称，支持模糊查询")
    private String itemCodeName;

    /**
     * 品项编号，支持模糊查询
     */
    @ApiModelProperty("品项编号，支持模糊查询")
    private String itemCode;

    /**
     * 品项名称，支持模糊查询
     */
    @ApiModelProperty("品项名称，支持模糊查询")
    private String itemName;

    /**
     * 规格型号，支持模糊查询
     */
    @ApiModelProperty("规格型号，支持模糊查询")
    private String spec;

    /**
     * 品类编号
     */
    @ApiModelProperty("品类编号")
    private String itemCateCode;

    /**
     * 品牌编号/名称，支持模糊查询
     */
    @ApiModelProperty("品牌编号/名称，支持模糊查询")
    private String brandCodeName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    /**
     * 供应商编号/名称，支持模糊查询
     */
    @ApiModelProperty("供应商编号/名称，支持模糊查询")
    private String suppCodeName;

    /**
     * 商品SKU状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    /**
     * 时间
     */
    @ApiModelProperty(value = "时间")
    private LocalDateTime statusTime;

    // ------------------------------ 2022-04-30---
    /**
     * 商品来源
     */
    @ApiModelProperty("商品来源")
    private String itemSource;

    /**
     * spu名称2
     */
    @ApiModelProperty("spu名称2")
    private String spuName2;
}

