package com.elitesland.yst.supportdomain.provider.item.service;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.provider.item.dto.*;
import com.elitesland.yst.supportdomain.provider.item.param.*;

import java.util.List;
import java.util.Map;

/**
 * @author Chris
 * @date 2021-04-27
 */
public interface ItmItemRpcService {

    /**
     * 保存商品数据
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param 保存参数
     * @return dto
     */
    Long saveItem(ItmItemSpuSaveRpcParam param);

    /**
     * 获取商品信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些商品基本信息，用于渲染
     * 2. 检查商品是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    List<ItmItemRpcDTO> findItemRpcDtoByParam(ItmItemRpcDtoParam param);

    /**
     * 获取商品信息分页列表ItmItemRpcPagingDTO  sku层面
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    PagingVO<ItmItemRpcPagingDTO> findItemRpcPagingByParam(ItmItemRpcPagingParam param);

    /**
     * 获取商品信息分页列表ItmItemRpcPagingDTO  spu层面
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    PagingVO<ItmItemSpuRpcPagingDTO> findItemSpuRpcPagingByParam(ItmItemSpuRpcPagingParam param);



    /**
     * 由于单商品会有很多单位转换数据
     * 为了防止获取单位转换接口被调用多次，该接口每次返回指定商品的所有单位转换信息
     * 获取商品单位转换系数列表，该接口应用如下场景
     * 1. 根据商品ID获取该商品所有的单位转换数据，由调用方自己做二次过滤
     * 12
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    List<ItmItemUomConvRpcDTO> findItemUomConvDtoByParam(ItmItemUomConvRpcDtoParam param);


    /**
     * 根据商品id   获取小类的 产品段值码  财务商品分类码 费用类码 财务分类
     * 同时返回该小类的中类大类编码
     *
     * @param itemIds 商品id 列表
     * @return dto
     */
    ItmItemCateContrPropRpcDTO findItemCateContPropDtoByItemId(List<Long> itemIds);

    /**
     * 根据品类编码 查询管控参数
     *
     * @param param 查询条件param
     * @return ItemCateContrPropRpcDTO
     */
    List<ItemCateContrPropRpcDTO> findItemCateContrPropByParam(ItemCateContrPropParam param);


    /**
     * 根据param查询商品经营目录信息
     *
     * @param param 查询条件
     * @return List<ItmItemBusinessRpcDTO>
     */
    List<ItmItemBusinessRpcDTO> findItmItemBusinessByParam(ItmItemBusinessRpcDtoParam param);

    /**
     * 获取经营目录商品信息分页列表
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoByParam(ItmItemBusinessRpcPagingParam param);

    /**
     * 根据小类的品类编码获取对应一级品类编码，二级品类编码，三级品类编码的列表
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     * @return ItmItemCateCodeRpcDTO
     */
    ItmItemCateCodeRpcDTO findCateCodeReItemCateCode(ItmItemCateCodeParam param);


    /**
     * 根据param 查询商品状态配置信息列表
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     * @return ItmBusinessTypeRpcDTO
     */
    List<ItmItemStatusConfigRpcDTO> findItmItemStatusConfigByParam(ItmItemStatusConfigRpcParam param);


    /**
     * 根据时间和商品信息 校验商品是否被冻结
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param 校验参数
     */
    void checkItemLifeStatusConfigByParam(ItmCheckLifeStatusRpcParam param);

    /**
     * 根据大类名称获取对应的品类数据
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     */
    Map<String, Map<String, Map<String, String>>> getItemCateInfoByBigCateName(ItmItemCateNameParam param);


    /**
     * 根据商品id、业务单位、数量  获取商品单位转换后的数据转换后的数据
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param params params
     * @return 转换后的数据
     */
    List<ItmItemUomConvCalcRpcDTO> getItemUomConvNumberByList(List<ItmItemUomConvCalcParam> params);


    /**
     * 获取品类树全部数据
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     * @return 转换后的数据
     */
    List<ItmItemCateTreeRpcDTO> itmItemCateSearchTree();
}
