package com.elitesland.yst.supportdomain.provider.org.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgAddrAddressRpcSaveParam implements Serializable {

    private static final long serialVersionUID = 111978593690482018L;
    /**
     * id
     */
    @ApiModelProperty("id")
    private Long id;

    /**
     * 地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE
     */
    @ApiModelProperty("地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE")
    private String addressType;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 联系人姓名
     */
    @ApiModelProperty("联系人姓名")
    private String contPerson;

    /**
     * 手机号码
     */
    @ApiModelProperty("手机号码")
    private String mobile;

    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String tel;

    /**
     * 传真
     */
    @ApiModelProperty("传真")
    private String fax;

    /**
     * 电邮
     */
    @ApiModelProperty("电邮")
    private String email;

    /**
     * 邮政编码
     */
    @ApiModelProperty("邮政编码")
    private String zipCode;

    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private String country;

    /**
     * 省份(编号/ID)
     */
    @ApiModelProperty("省份(编号/ID)")
    private String province;

    /**
     * 城市(编号/ID)
     */
    @ApiModelProperty("城市(编号/ID)")
    private String city;

    /**
     * 区县(编号/ID)
     */
    @ApiModelProperty("区县(编号/ID)")
    private String county;

    /**
     * 街道/乡镇(文本)
     */
    @ApiModelProperty("街道/乡镇(文本)")
    private String street;

    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String detailAddr;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private String dataSource;

    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;

    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;

    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;

    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    /**
     * ES6
     */
    @ApiModelProperty("ES6")
    private String es6;

    /**
     * ES7
     */
    @ApiModelProperty("ES7")
    private String es7;

    /**
     * ES8
     */
    @ApiModelProperty("ES8")
    private String es8;

    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    private String es9;

    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private String es10;
}
