package com.elitesland.yst.supportdomain.provider.org.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author: zhanghang
 * @create: 2022-04-26 13:27
 **/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrgAddrQueryRpcParam implements Serializable {
    private static final long serialVersionUID = 9165653872469241882L;

    /**
     * 地址号
     */
    @ApiModelProperty("地址号")
    private Long addrNo;

    /**
     * 获取对应来源的数据 udc
     */
    @ApiModelProperty("数据来源；如果列表为空，则返回所有来源的数据")
    private List<String> dataSources;

}
