package com.elitesland.yst.supportdomain.provider.org.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/10
 */
@Data
@ApiModel("BU组织列表参数")
public class OrgBuRemotePagingParam implements Serializable {


    private static final long serialVersionUID = -4161578758616356205L;

    /**
     * 组织编号、名称、简称
     */
    @ApiModelProperty("组织编号、名称、简称")
    private String buCodeNameLike;

    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private String ouId;

    /**
     * 组织类型 [UDC]ORG:BU_TYPE
     */
    @ApiModelProperty("组织类型 [UDC]ORG:BU_TYPE")
    private String buType;

    /**
     * 组织状态 [UDC]ORG:BU_STATUS
     */
    @ApiModelProperty("组织状态 [UDC]ORG:BU_STATUS")
    private String buStatus;

    /**
     * 页码,默认为1
     */
    @ApiModelProperty(value = "页码,默认为1", example = "0")
    private Integer current = 0;

    /**
     * 页大小,默认为10
     */
    @ApiModelProperty(value = "页大小,默认为10", example = "10")
    private Integer size = 10;
}
