package com.elitesland.yst.supportdomain.provider.org.service;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgOuUserRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpBuDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgOuUserRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.org.param.OrgUserIdBuParam;

import java.util.List;

/**
 * @author Chris
 * @date 2021-07-21
 */
public interface OrgUserEmpBuRpcService {

    /**
     * 根据用户账号ID，获取绑定的员工组织信息
     * @param userId 用户账号ID
     * @return 绑定员工组织信息
     */
    ApiResult<OrgUserEmpBuDTO> findUserEmpBuInfoByUserId(Long userId);

    /**
     * 根据公司ID获取公司下所有员工绑定的用户账号ID
     * @param param 查询参数
     * @return 用户账号ID
     */
    ApiResult<List<Long>> findUserIdsByParam(OrgUserIdBuParam param);

    /**
     * 查询公司绑定的用户
     * @param param 查询条件
     * @return 用户信息
     */
    List<OrgOuUserRpcDTO> findOuUserByParam(OrgOuUserRpcDtoParam param);
}
