package com.elitesland.tms.api.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.tms.api.Application;
import com.elitesland.tms.api.dto.TmsKuaidiContextDTO;
import com.elitesland.tms.api.vo.TmsKuadiVO;
import com.elitesland.tms.api.vo.TmsKuaidiSearchVO;
import com.elitesland.tms.api.vo.TmsKuaidiSubscribeVO;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + TmsKuaiDiProvider.PATH)
public interface TmsKuaiDiProvider {
    String PATH = "/rpc/kuaidi";

    @PostMapping("/subscribe")
    ApiResult<Void> subscribe(@Validated @RequestBody TmsKuaidiSubscribeVO tmsKuaidiSubscribeVO);

    /**
     * 直调快递100
     * @param tmsKuaidiSubscribeVO
     * @return
     */
    @PostMapping("/query/kuaidi100")
    ApiResult<TmsKuaidiContextDTO> queryTrack(@Validated @RequestBody TmsKuaidiSubscribeVO tmsKuaidiSubscribeVO);

    /**
     * 物流域调用查询（未订阅的无数据）
     * @param tmsKuaidiSubscribeVO
     * @return
     */
    @PostMapping("/query/kuaidi")
    ApiResult<List<TmsKuadiVO>> queryDetail(@Validated @RequestBody TmsKuaidiSearchVO tmsKuaidiSubscribeVO);


}
