package com.elitesland.tms.api.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;



/**
 * 功能说明 实体类:TmsKuadi
 *
 * @author hu
 * @date 2023-12-20 10:56:33
 */
@Data
public class TmsKuadiVO extends BaseModelVO implements Serializable {
private static final long serialVersionUID =2992493615878099206L;

	/**
	 * 单号
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "单号")
	private String nu;

	/**
	 * 监控状态
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "监控状态")
	private String status;

	/**
	 * 消息
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "消息")
	private String message;

	/**
	 * 是否签收标记
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "是否签收标记")
	private String isCheck;

	/**
	 * 快递单当前状态
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "快递单当前状态")
	private String state;

	@ApiModelProperty(value = "快递单当前状态")
	@SysCode(sys = "yst-tms", mod = "KUAI_DI_STATE")
	private String stateName;

	/**
	 * 快递公司编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "快递公司编码")
	private String com;

	/**
	 * 发出地 （不一定存在）
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "发出地")
	private String fromNumber;

	/**
	 * 发出地 （不一定存在）
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "发出地")
	private String fromName;

	/**
	 * 收货地 （不一定存在）
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "收货地")
	private String curNumber;

	/**
	 * 收货地 （不一定存在）
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "收货地")
	private String curName;

	@ApiModelProperty(value = "详情")
	List<TmsKuadiDetailVO> tmsKuadiDetailVOS;


	
}
