package com.elitesland.yst.wms.connector.client;

import cn.hutool.core.lang.UUID;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitesland.yst.wms.connector.util.CommonUtil;
import com.elitesland.yst.wms.connector.util.YstHashMap;
//import com.elitesland.yst.wms.connector.taobao.internal.util.TaobaoHashMap;

import java.time.LocalDateTime;

import cn.hutool.json.JSONUtil;
import com.elitesland.yst.wms.connector.DTO.YstWmsCallRequestDTO;
import com.elitesland.yst.wms.connector.config.YstWmsRequestClientConfig;
import com.qimen.api.QimenClient;

import com.qimen.api.QimenRequest;
import com.qimen.api.QimenResponse;
import com.taobao.api.ApiException;
import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.DnsConfig;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

/**
 * @author : chen.niu
 * @description : 云时通WMS标准服务客户端 推荐
 * @date : 2025-03-25 14:38
 */
public class YstWmsRequestClient implements QimenClient {
    public static final String APP_KEY = "AppKey";
    public static final String APP_SECRET = "AppSecret";
    public static final String API_METHOD_NAME = "ApiMethodName";
    public static final String RESPONSE_CLASS = "ResponseClass";
    public static final String REQUEST_CLASS = "RequestClass";

    //主调 erp->wms
    public static final String ACTIVE_CALL_API_URL = "/wms/router/active/call";
    //被调 wms-erp
    public static final String PASSIVE_CALL_API_URL = "/wms/router/passive/call";

    //    protected String appKey;
//    protected String appSecret;
//    protected String sysCode;
//    protected String serverUrl;
//    protected String bizType ;//业务类型
    //private String customerid;
    protected String format = "xml";

    protected String signMethod = "md5";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needEnableParser = true;
    protected boolean useGzipEncoding = true;
    private boolean isHttpDnsEnabled = false;
    private String originalHttpHost = null;

    private YstWmsRequestClientConfig ystWmsRequestClientConfig;
    private RestTemplate restTemplate = new RestTemplate();

    /**
     * 可以重新设置restTemplate 配置需要的参数
     */
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }


    public YstWmsRequestClient(YstWmsRequestClientConfig ystWmsRequestClientConfig) {
//        this.sysCode=sysCode;
//        this.appKey = appKey;
//        this.appSecret = appSecret;
//        this.serverUrl = serverUrl;
        ystWmsRequestClientConfig.validateConfig();
        this.ystWmsRequestClientConfig = ystWmsRequestClientConfig;
    }

    @Override
    public <T extends QimenResponse> T execute(QimenRequest<T> request) throws ApiException {
        return this.execute(request, (String) null);
    }

    @Override
    public <T extends QimenResponse> T execute(QimenRequest<T> request, String session) throws ApiException {
        return this._execute(request, session);
    }

    private YstWmsCallRequestDTO ystWmsRequestDTO;

    /**
     * 可以获取商城执行的请求对象.  关键参数 YstWmsRequestDTO.reqUUid. 请求唯一标识,可以查询日志.
     */
    public YstWmsCallRequestDTO getExecuteYstWmsRequestDTO() {
        return ystWmsRequestDTO;
    }

    private <T extends QimenResponse> T _execute(QimenRequest<T> request, String session) throws ApiException {
        long start = System.currentTimeMillis();

        String realServerUrl = ystWmsRequestClientConfig.getServerBaseUrl();

        try {
            ystWmsRequestDTO = getYstWmsRequestDTO(request);
            String apiBody = JSONUtil.toJsonStr(ystWmsRequestDTO);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity<String> entity = new HttpEntity<>(apiBody, headers);
            String response = restTemplate.exchange(realServerUrl + ACTIVE_CALL_API_URL,
                            HttpMethod.POST, entity, String.class)
                    .getBody();

            return JSONUtil.toBean(response, request.getResponseClass());
        } catch (Exception var17) {
            var17.printStackTrace();
            throw new ApiException(var17);
        }
    }

    @NotNull
    public <T extends QimenResponse> YstWmsCallRequestDTO getYstWmsRequestDTO(QimenRequest<T> request) {
//        request.setYstSysTenantCode(ystWmsRequestClientConfig.getYstSysTenantCode());
        String requestJson = JSONUtil.toJsonStr(request);

        YstWmsCallRequestDTO ystWmsRequestDTO = new YstWmsCallRequestDTO();
        ystWmsRequestDTO.setSourceAppCode(ystWmsRequestClientConfig.getSourceAppCode());
        ystWmsRequestDTO.setSourceSysCode(ystWmsRequestClientConfig.getSourceSysCode());
        ystWmsRequestDTO.setSourceAppSecret(ystWmsRequestClientConfig.getSourceAppSecret());

        ystWmsRequestDTO.setCustomerId(request.getCustomerId());
        //设置云时通租户编码 已废弃 通过配置文件完成
//        ystWmsRequestDTO.setYstSysTenantCode(ystWmsRequestClientConfig.getYstSysTenantCode());
        ystWmsRequestDTO.setReqUserId(request.getReqUserId());
        ystWmsRequestDTO.setReqUserName(request.getReqUserName());
        ystWmsRequestDTO.setWmsSysCode(ystWmsRequestClientConfig.getWmsSysCode());
        ystWmsRequestDTO.setWmsAppKey(ystWmsRequestClientConfig.getWmsAppKey());
        ystWmsRequestDTO.setWmsAppSecret(ystWmsRequestClientConfig.getWmsAppSecret());
        ystWmsRequestDTO.setServerBaseUrl(ystWmsRequestClientConfig.getServerBaseUrl());
        ystWmsRequestDTO.setQueryParam((YstHashMap) request.getQueryParams());
        ystWmsRequestDTO.setRequestApiMethodName(request.getApiMethodName());
        ystWmsRequestDTO.setRequestBodyJson(requestJson);

        ystWmsRequestDTO.setRequestClass(request.getClass().getName());
        ystWmsRequestDTO.setResponseClass(request.getResponseClass().getName());

        ystWmsRequestDTO.setBizType(request.getApiMethodName());
        ystWmsRequestDTO.setReqMethod(HttpMethod.POST);
//        ystWmsRequestDTO.setReqHeaders(request.getHeaders()));
        ystWmsRequestDTO.setClientId("YstWmsRequestClient");
        ystWmsRequestDTO.setReqIp(HttpServletUtil.currentClientIp()!=null?HttpServletUtil.currentClientIp():CommonUtil.getServerIp());
        ystWmsRequestDTO.setReqTime(LocalDateTime.now());
        ystWmsRequestDTO.setReqUUid(UUID.randomUUID().toString());
        ystWmsRequestDTO.setReqUri(ystWmsRequestClientConfig.getServerBaseUrl() + ACTIVE_CALL_API_URL);
        return ystWmsRequestDTO;
    }


    public String getServerUrl(String serverUrl) {
        if (this.isHttpDnsEnabled) {
            DnsConfig dnsConfig = ClusterManager.GetDnsConfigFromCache();
            return dnsConfig == null ? serverUrl : dnsConfig.getVipUrl(serverUrl);
        } else {
            return serverUrl;
        }
    }


}